<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Balance Sheet</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.2.19/tailwind.min.css" rel="stylesheet">
</head>

<body class="bg-gray-100 p-8">

    <div class="max-w-2xl mx-auto bg-white p-4 rounded shadow">
        <h2 class="text-2xl font-bold mb-4">Balance Sheet</h2>

        <?php
        $accountingData = json_decode(file_get_contents('accounting_data.json'), true);

        $totalAssets = $totalLiabilitiesEquity = 0;

        foreach ($accountingData as $account => $balance) {
            if ($balance >= 0) {
                $totalAssets += $balance;
            } else {
                $totalLiabilitiesEquity += abs($balance);
            }
        }
        ?>

        <table class="min-w-full border border-black border-collapse mb-4">
            <thead>
                <tr class="bg-gray-200">
                    <th class="border border-black py-2 px-4">Assets</th>
                    <th class="border border-black py-2 px-4">Liabilities + Equity</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="border border-black py-2 px-4"><?php echo $totalAssets; ?></td>
                    <td class="border border-black py-2 px-4"><?php echo $totalLiabilitiesEquity; ?></td>
                </tr>
            </tbody>
        </table>
    </div>

</body>

</html>
